FUNCTION handlemcode()
    DIM temp AS FLOAT
    temp = TABLE(comms_mcode)
    SELECT_CASE temp
        CASE 0,5
            spindlestop() 'Spindle stop
        CASE 3
            spindlestartcw() 'Spindle CW
        CASE 4
            spindlestartccw() 'Spindle CCW

        CASE 8
            coolanton()
        CASE 9
            coolantoff()

        CASE 10
            setvice(1) 'Vice Open
        CASE 11
            setvice(0) 'Vice Close
        CASE 24
            drawbarunclamp() 'Drawbar Unclamp
        CASE 25
            drawbarclamp() 'Drawbar Clamp


        CASE 38
            mcode38()'guard OPEN
        CASE 39
            mcode39()'guard CLOSE

        CASE 45
            mcode45()
        CASE 62
            mcode62()
        CASE 63
            mcode63()
        CASE 64
            mcode64()
        CASE 65
            mcode65()
        CASE 66
            mcode66()
        CASE 67
            mcode67()
        CASE 76
            mcode76()
        CASE 77
            mcode77()

    END_CASE
    IF (VR(vr_machine) = vmc1300) OR (VR(vr_machine) = vmc1300pro) THEN
        SELECT_CASE temp
            CASE 20
                zup()
                tcclearpos()
                tctablein()
            CASE 21
                zup()
                tcclearpos()
                tctablenearlyin()
            CASE 32
                carouselcw()
            CASE 33
                carouselccw()
            CASE 34
                carouselhalf()
            CASE 27
                VR(vr_tool) = 1
        END_CASE
    ENDIF
    TABLE(comms_task,0)
ENDFUNC

FUNCTION drawbarunclamp( )
    spindlestop()

    IF NOT checkavailableairpressure() THEN
        DIM machproblem AS INTEGER
        machproblem = TABLE(comms_machproblem) OR 4
        TABLE(comms_machproblem, machproblem)
        raiseevent(comms_machproblem)
        RETURN 'The air pressure switches off when air is running low
    ENDIF
    OP(output_toolreleasedrawbar,1)
    WA(1500)

ENDFUNC

FUNCTION drawbarclamp( )
    IF NOT checkavailableairpressure() THEN
        DIM machproblem AS INTEGER
        machproblem = TABLE(comms_machproblem) OR 4
        TABLE(comms_machproblem, machproblem)
        raiseevent(comms_machproblem)
        RETURN 'The air pressure switches off when air is running low
    ENDIF
    OP(output_toolreleasedrawbar,0)
    WA(1500)
ENDFUNC

FUNCTION setvice(viceon AS INTEGER)
    spindlestop()
    OP(output_viceopen, viceon)
    SERVO AXIS(1)=OFF
    IF viceon THEN
        DAC AXIS(2) = servo_axis_on
    ELSE
        DAC AXIS(2) = servo_axis_off
    ENDIF
    SERVO AXIS(1)=ON
ENDFUNC


FUNCTION spindlestop()
    'Only stop the spindle if it was already running
    IF TABLE(table_spindlerunning) = ON THEN
        OP(output_spindleenable, OFF)
        WA(5000)
        TABLE(table_spindlerunning,OFF)
        OP(output_guardlock, ON)
        DAC AXIS(0)=servo_axis_off
    ENDIF
ENDFUNC

FUNCTION spindlestartcw()
    IF ismachinesafe() AND (READ_OP(output_toolreleasedrawbar) = OFF) THEN
        OP(output_guardlock, OFF)
        setspindlespeed(TABLE(comms_speed))
        TABLE(table_spindlerunning,ON)
        OP(output_spindleenable, ON)
    ENDIF
ENDFUNC

FUNCTION spindlestartccw()
    IF ismachinesafe() AND (READ_OP(output_toolreleasedrawbar) = OFF) THEN
        OP(output_guardlock, OFF)
        setspindlespeed(TABLE(comms_speed))
        TABLE(table_spindlerunning,ON)
        OP(output_spindleenable, ON)
    ENDIF
ENDFUNC

FUNCTION coolanton( )
    OP(output_coolanton, ON)
ENDFUNC

FUNCTION coolantoff( )
    OP(output_coolanton, OFF)
ENDFUNC

FUNCTION setaxesfortoolchangespeed()
    FOR axiscount = 0 TO TABLE(comms_numaxes)-1
        BASE(axiscount)
        SPEED = 2* toolchangespeed * TABLE(comms_steppermm) / 60
    NEXT axiscount
ENDFUNC

FUNCTION toolchange(tool AS INTEGER)
    spindlestop()
    IF TABLE(comms_atc) = 0 THEN
        VR(vr_tool) = tool
        RETURN
    ENDIF
    IF VR(vr_tool) = tool THEN
        RETURN
    ENDIF

    DIM machproblem AS INTEGER
    machproblem = 0
    TABLE(comms_machproblem, 0)
    raiseevent(comms_machproblem)
    WA(200)
    IF IN(input_toolchangerfitted) = OFF THEN
        machproblem = machproblem OR 8 ' warn that TC not fitted but should be according to
    ENDIF

    IF NOT checkavailableairpressure() THEN
        machproblem = machproblem OR 4 ' warn that TC not fitted but should be according to
    ENDIF
    IF machproblem <> 0 THEN
        raiseevent(comms_machproblem)
        RETURN 'The air pressure switches off when air is running low
    ENDIF

    DIM coolantwason AS BOOLEAN
    coolantwason = (READ_OP(output_coolanton) = ON)
    coolantoff()
    ' Mcodes to manually perform parts of these sequences:
    'M20 will perform ZUp : TCClearPos : TCTableIn :
    'M21 will perform ZUp : TCClearPos : TCTableNearlyIn :
    'M24 DrawbarUnClamp
    'M25 DrawbarClamp
    'M27 Set current tool/carousel position to 1
    'M32 CarouselCW
    'M33 CarouselCCW
    'M34 CarouselHalf

    setaxesfortoolchangespeed()

    BASE(0)
    IF checkavailableairpressure() AND NOT cyclereset() THEN tcclearpos()
    IF checkavailableairpressure() AND NOT cyclereset() THEN tctablenearlyin()
    IF checkavailableairpressure() AND NOT cyclereset() THEN zdown()
    IF checkavailableairpressure() AND NOT cyclereset() THEN tctablein()
    IF checkavailableairpressure() AND NOT cyclereset() THEN drawbarunclamp()
    IF checkavailableairpressure() AND NOT cyclereset() THEN zup()

    BASE(0)
    DIM steps AS INTEGER
    steps = (tool - VR(vr_tool) + vmcnumberoftools()) MOD vmcnumberoftools()
    IF steps > (vmcnumberoftools() / 2) THEN
        WHILE (VR(vr_tool) <> tool) AND checkavailableairpressure() AND NOT cyclereset()
            carouselcw()
        WEND
    ELSE
        WHILE (VR(vr_tool) <> tool) AND checkavailableairpressure() AND NOT cyclereset()
            carouselccw()
        WEND
    ENDIF

    IF checkavailableairpressure() AND NOT cyclereset() THEN zdown()
    IF checkavailableairpressure() AND NOT cyclereset() THEN drawbarclamp()
    IF checkavailableairpressure() AND NOT cyclereset() THEN tctablenearlyin()
    IF checkavailableairpressure() AND NOT cyclereset() THEN zup()
    IF checkavailableairpressure() AND NOT cyclereset() THEN tctablehome()

    setfeedspeed()
ENDFUNC

FUNCTION carouselhalf ()
    OP(output_caroceldirection,1)
    OP(output_carocelpower,1)
    WA(50)
    WAIT UNTIL (IN(input_carocelcounter) = ON) OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = ON) OR cyclereset()
    WAIT UNTIL (IN(input_carocelcounter) = ON) OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = ON) OR cyclereset()

    WAIT UNTIL (IN(input_carocelcounter) = OFF) OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = OFF) OR cyclereset()
    WAIT UNTIL (IN(input_carocelcounter) = OFF) OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = OFF) OR cyclereset()

    'WA(100)
    OP(output_carocelpower,0)
    VR(vr_tool) = VR(vr_tool) -1
    IF VR(vr_tool) < 1 THEN
        VR(vr_tool) =vmcnumberoftools()
    ENDIF


ENDFUNC

FUNCTION carouselcw ()
    OP(output_caroceldirection,1)
    OP(output_carocelpower,1)
    WA(50)
    WAIT UNTIL IN(input_carocelcounter) = ON OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = ON) OR cyclereset()
    WAIT UNTIL IN(input_carocelcounter) = ON OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = ON) OR cyclereset()

    WAIT UNTIL IN(input_carocelcounter) = OFF OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = OFF) OR cyclereset()
    WAIT UNTIL IN(input_carocelcounter) = OFF OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = OFF) OR cyclereset()

    WAIT UNTIL IN(input_carocelcounter) = ON OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = ON) OR cyclereset()
    WAIT UNTIL IN(input_carocelcounter) = ON OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = ON) OR cyclereset()

    WAIT UNTIL IN(input_carocelcounter) = OFF OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = OFF) OR cyclereset()
    WAIT UNTIL IN(input_carocelcounter) = OFF OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = OFF) OR cyclereset()
    'WA(100)
    OP(output_carocelpower,0)
    VR(vr_tool) = VR(vr_tool) -1
    IF VR(vr_tool) < 1 THEN
        VR(vr_tool) =vmcnumberoftools()
    ENDIF


ENDFUNC

FUNCTION carouselccw ()
    OP(output_caroceldirection,0)
    OP(output_carocelpower,1)
    WA(50)
    WAIT UNTIL IN(input_carocelcounter) = ON OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = ON) OR cyclereset()
    WAIT UNTIL IN(input_carocelcounter) = ON OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = ON) OR cyclereset()

    WAIT UNTIL IN(input_carocelcounter) = OFF OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = OFF) OR cyclereset()
    WAIT UNTIL IN(input_carocelcounter) = OFF OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = OFF) OR cyclereset()

    WAIT UNTIL IN(input_carocelcounter) = ON OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = ON) OR cyclereset()
    WAIT UNTIL IN(input_carocelcounter) = ON OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = ON) OR cyclereset()

    WAIT UNTIL IN(input_carocelcounter) = OFF OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = OFF) OR cyclereset()
    WAIT UNTIL IN(input_carocelcounter) = OFF OR cyclereset()
    REPEAT
        WA(10)
    UNTIL (IN(input_carocelcounter) = OFF) OR cyclereset()
    'WA(100)
    OP(output_carocelpower,0)
    VR(vr_tool) = VR(vr_tool) +1
    IF VR(vr_tool) > vmcnumberoftools() THEN
        VR(vr_tool) =1
    ENDIF
ENDFUNC

' Move X, Y and Z to initial positions
FUNCTION tcclearpos ()
    setaxesfortoolchangespeed()
    DIM stepspermm AS INTEGER
    stepspermm =TABLE(comms_steppermm)

    BASE(2)
    'toolchangezup = 1
    MOVEABS(toolchangezup * stepspermm)
    WA(200)
    WAIT UNTIL checkisidle() OR cyclereset()


    'toolchangexhome = 5
    'toolchangeycentre = -69
    'toolchangezup = 1




    BASE(0)
    MOVEABS(toolchangexhome * stepspermm, toolchangeycentre *stepspermm, toolchangezup * stepspermm)
    WA(200)
    WAIT UNTIL checkisidle() OR cyclereset()


ENDFUNC

FUNCTION tctablenearlyin()
    setaxesfortoolchangespeed()
    DIM stepspermm AS INTEGER
    stepspermm =TABLE(comms_steppermm)

    BASE(0)
    'toolchangexnearlyin = -290

    MOVEABS(toolchangexnearlyin * stepspermm)
    WA(200)
    WAIT UNTIL checkisidle() OR cyclereset()
ENDFUNC

FUNCTION zdown()
    setaxesfortoolchangespeed()
    DIM stepspermm AS INTEGER
    stepspermm =TABLE(comms_steppermm)

    BASE(2)

    MOVEABS((toolchangezdown + TABLE(comms_tcheightadjust) ) * stepspermm)
    WA(200)
    WAIT UNTIL checkisidle() OR cyclereset()
ENDFUNC

FUNCTION tctablein()
    setaxesfortoolchangespeed()
    DIM stepspermm AS INTEGER
    stepspermm =TABLE(comms_steppermm)

    BASE(0)
    'toolchangexin = -367
    DIM currentmaximum AS INTEGER
    currentmaximum = RS_LIMIT
    RS_LIMIT = -REP_DIST - 100


    MOVEABS(toolchangexin * stepspermm)
    WA(200)
    WAIT UNTIL checkisidle() OR cyclereset()
    RS_LIMIT = currentmaximum
ENDFUNC

FUNCTION zup()
    setaxesfortoolchangespeed()
    DIM stepspermm AS INTEGER
    stepspermm =TABLE(comms_steppermm)

    BASE(2)

    'toolchangezup = 1

    MOVEABS(0,0,toolchangezup * stepspermm)
    WA(200)
    WAIT UNTIL checkisidle() OR cyclereset()
ENDFUNC


FUNCTION tctablehome ( )
    setaxesfortoolchangespeed()
    DIM stepspermm AS INTEGER
    stepspermm =TABLE(comms_steppermm)

    BASE(0)
    'toolchangexhome = -5

    MOVEABS(toolchangexhome * stepspermm)
    WA(200)
    WAIT UNTIL checkisidle() OR cyclereset()
ENDFUNC

FUNCTION mcode38()
    IF (VR(vr_machine) = vmc1300pro) THEN
        'guard OPEN
        SERVO AXIS(3)=OFF
        DAC AXIS(3) = servo_axis_off
        SERVO AXIS(3)=ON
    ENDIF
ENDFUNC

FUNCTION mcode39()
    IF (VR(vr_machine) = vmc1300pro) THEN
        'guard CLOSE
        SERVO AXIS(3)=OFF
        DAC AXIS(3) = servo_axis_on
        SERVO AXIS(3)=ON
    ENDIF
ENDFUNC

FUNCTION mcode45()
    WA(2000)
    BASE(TABLE(comms_captureaxis1))
    MOVESP(TABLE(comms_capturemove1))

    BASE(0,1,2)
ENDFUNC

FUNCTION mcode62()
    IF (VR(vr_machine) = micromillpro) THEN
        OP(output_auxout1rmicroturn, ON)
    ELSEIF (VR(vr_machine) = vmc1300pro) THEN
        SERVO AXIS(1)=OFF
        DAC AXIS(1) = servo_axis_on
        SERVO AXIS(1)=ON
        OP(output_auxout1r, ON)
    ENDIF
ENDFUNC

FUNCTION mcode63()
    IF (VR(vr_machine) = vmc1300pro) THEN
        OP(output_auxout2r, ON)
        SERVO AXIS(2)=OFF
        DAC AXIS(2) = servo_axis_on
        SERVO AXIS(2)=ON
        OP(output_auxout1r, ON)
    ENDIF
ENDFUNC

FUNCTION mcode64()
    IF (VR(vr_machine) = micromillpro) THEN
        OP(output_auxout1rmicroturn, OFF)
    ELSEIF (VR(vr_machine) = vmc1300pro) THEN
        SERVO AXIS(1)=OFF
        DAC AXIS(1) = servo_axis_off
        SERVO AXIS(1)=ON
        OP(output_auxout1r, OFF)
    ENDIF
ENDFUNC

FUNCTION mcode65()
    IF (VR(vr_machine) = vmc1300pro) THEN
        SERVO AXIS(2)=OFF
        DAC AXIS(2) = servo_axis_off
        SERVO AXIS(2)=ON
        OP(output_auxout2r, OFF)
    ENDIF
ENDFUNC

FUNCTION mcode66()
    IF (VR(vr_machine) = micromillpro) THEN
        WAIT UNTIL (IN(input_waitforinputr) = ON) OR cyclereset()
    ELSEIF (VR(vr_machine) = vmc1300pro) THEN
        WAIT UNTIL (IN(input_input1waitr) = ON) OR cyclereset()
    ENDIF
ENDFUNC

FUNCTION mcode67()
    IF (VR(vr_machine) = vmc1300pro) THEN
        WAIT UNTIL (IN(input_input2vicer) = ON) OR cyclereset()
    ENDIF
ENDFUNC

FUNCTION mcode76()
    IF (VR(vr_machine) = micromillpro) THEN
        WAIT UNTIL (IN(input_waitforinputr) = OFF) OR cyclereset()
    ELSEIF (VR(vr_machine) = vmc1300pro) THEN
        WAIT UNTIL (IN(input_input1waitr) = OFF) OR cyclereset()
    ENDIF
ENDFUNC

FUNCTION mcode77()
    IF (VR(vr_machine) = vmc1300pro) THEN
        WAIT UNTIL (IN(input_input2vicer) = OFF) OR cyclereset()
    ENDIF
ENDFUNC


